/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_12_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_12_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class CatServerEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockBreakEvent bukkitEvent = CraftEventFactory.callBlockBreakEvent(event.getWorld(), event.getPos(), event.getState(), (oq)event.getPlayer());
        if (bukkitEvent.isCancelled()) {
            event.setCanceled(true);
        } else {
            event.setExpToDrop(bukkitEvent.getExpToDrop());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        BlockPlaceEvent bukkitEvent;
        et clickPos;
        et et2 = clickPos = event.direction != null ? event.getBlockSnapshot().getPos().a(event.direction.d()) : event.getPos();
        if (event instanceof BlockEvent.MultiPlaceEvent) {
            BlockEvent.MultiPlaceEvent multiPlaceEvent = (BlockEvent.MultiPlaceEvent)event;
            ArrayList<BlockState> list = new ArrayList<BlockState>();
            for (BlockSnapshot snap : multiPlaceEvent.getReplacedBlockSnapshots()) {
                et blockPos = snap.getPos();
                list.add(CraftBlockState.getBlockState(event.getWorld(), blockPos.p(), blockPos.q(), blockPos.r()));
            }
            bukkitEvent = CraftEventFactory.callBlockMultiPlaceEvent(event.getWorld(), event.getPlayer(), event.getHand(), list, clickPos.p(), clickPos.q(), clickPos.r());
        } else {
            et blockPos = event.getPos();
            CraftBlockState blockstate = CraftBlockState.getBlockState(event.getWorld(), blockPos.p(), blockPos.q(), blockPos.r());
            bukkitEvent = CraftEventFactory.callBlockPlaceEvent(event.getWorld(), event.getPlayer(), event.getHand(), blockstate, clickPos.p(), clickPos.q(), clickPos.r());
        }
        if (bukkitEvent.isCancelled() || !bukkitEvent.canBuild()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PlayerInteractEvent bukkitEvent;
        if (!event.isVanilla && (bukkitEvent = CraftEventFactory.callPlayerInteractEvent(event.getEntityPlayer(), Action.LEFT_CLICK_BLOCK, event.getPos(), event.getFace(), event.getItemStack(), false, event.getHand())).useInteractedBlock() == Event.Result.DENY) {
            event.setCanceled(true);
            event.setCancellationResult(bukkitEvent.useItemInHand() != Event.Result.ALLOW ? ud.a : ud.b);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerInteractEvent bukkitEvent;
        if (!event.isVanilla && (bukkitEvent = CraftEventFactory.callPlayerInteractEvent(event.getEntityPlayer(), Action.RIGHT_CLICK_BLOCK, event.getPos(), event.getFace(), event.getItemStack(), false, event.getHand())).useInteractedBlock() == Event.Result.DENY) {
            event.setCanceled(true);
            event.setCancellationResult(bukkitEvent.useItemInHand() != Event.Result.ALLOW ? ud.a : ud.b);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Bukkit.getPluginManager().callEvent(new PlayerChangedWorldEvent((Player)((CraftPlayer)event.player.getBukkitEntity()), MinecraftServer.getServerInst().getWorldServer(event.fromDim).getWorld()));
    }
}

